﻿using UnityEngine;
using UnityEngine.UI;

public class XRCamera : MonoBehaviour {
    public GameObject modelLoader;
    public float adjustHeight = 1.36f;
    public float rotationSpeed = 60f;
    public Text info;
    public SppExplosionBehaviour explosionHandler;

    private float distanceMin;
    private float distanceMax;
    private float curDistance;

    private float curX;
    private float curY;
    private Transform root;
    private float explosion = 0f;
    private float zoomSpeed = 1f;
    void Update()
    {
        float x;
        float y;

        // Touchpad und Mode (rotate/zoom/explode)
        if (Input.GetButton(XRInput.TouchpadClick))
        {
            // zoom/ explode
            x = Input.GetAxis(XRInput.TouchpadX);
            y = Input.GetAxis(XRInput.TouchpadY);

            if (Mathf.Abs(x) > Mathf.Abs(y))
            {
                if (explosionHandler != null)
                {
                    // explode
                    if (x > 0)
                    {
                        explosion = Increment(explosion, 1f, 1f, Time.deltaTime);
                    }
                    else if (x < 0)
                    {
                        explosion = Decrement(explosion, 0f, 1f, Time.deltaTime);
                    }
                    explosionHandler.Explode(explosion);
                }
            }
            else
            {
                // Zoom
                if (y < 0)
                {
                    curDistance = Increment(curDistance, distanceMax, 1f, Time.deltaTime * zoomSpeed);
                }
                else if (y > 0)
                {
                    curDistance = Decrement(curDistance, distanceMin, 1f, Time.deltaTime*zoomSpeed);
                }
                modelLoader.transform.position = new Vector3(modelLoader.transform.position.x, modelLoader.transform.position.y, curDistance);
            }
        }
        else if (Input.GetButton(XRInput.TouchpadTouch))

        {
            // rotate
            x = Input.GetAxis(XRInput.TouchpadX);
            y = Input.GetAxis(XRInput.TouchpadY);

            if (Mathf.Abs(x) > Mathf.Abs(y))
            {
                if (x != 0f)
                {
                    curX += (x * rotationSpeed * Time.deltaTime);
                    modelLoader.transform.eulerAngles = new Vector3(curY, -curX, 0f);
                }

            }
            else
            {
                if (y != 0f)
                {
                    curY -= (y * rotationSpeed * Time.deltaTime);
                    modelLoader.transform.eulerAngles = new Vector3(curY, -curX, 0f);
                }

            }
        }
    }

    public void SetDistanceMin(float distanceMin)
    {
    }

    public void SetDistanceMax(float distanceMax)
    {
    }

    public void CamDistance(float distance)
    {
        if (info!=null)
        {
            info.enabled = false;
        }
        if (modelLoader)
        {
            root = modelLoader.transform;
            if (root != null)
            {
                Bounds b = SppUtility.GetBoundingBox(root);
                distanceMin = Mathf.Max(b.size.z, b.size.x) *0.5f;
                distanceMax = distanceMin * 4f;
                curDistance = distanceMin *3f;
                zoomSpeed = (distanceMax - distanceMin) / 2f;
                Vector3 vDistance = -Camera.main.transform.forward * curDistance;
                vDistance.y = adjustHeight;
                modelLoader.transform.position = new Vector3(0f, adjustHeight, curDistance );
                curX = 0f;
                curY = 0f;
                explosion = 0f;
            }
            else
            {
                Debug.LogWarning("Root not found!!!");
            }
        } else
        {
            Debug.LogWarning("No ModelLoader specified!");
        }
    }

    private static float Increment(float cur, float max, float speed, float deltaTime)
    {
        float f  = (cur + speed * deltaTime);
        if (f > max)
            f = max;
        return f;
    }

    private static float Decrement(float cur, float min, float speed, float deltaTime)
    {
        float f = (cur - speed * deltaTime);
        if (f < min)
            f = min;
        return f;
    }

    private static float ZoomToFit(float min, float max, float height)
    {
        const int STEPS = 10;
        float dist = (max-min)/STEPS;
        float retVal = max;
        for (int i = 0; i < STEPS; i++)
        {
            float frustumHeight = 2.0f * (max - i*dist) * Mathf.Tan(Camera.main.fieldOfView * 0.5f * Mathf.Deg2Rad);
            if (frustumHeight < height)
            {
                break;
            }
            retVal = max - i * dist;
        }
        return retVal;
    }
}
